// =============================================================
// Testbench for FORTH-Processor K1
//
// Author   : Klaus Kohl-Schoepe
// Date     : 11.05.2020
// File Name: Testbench_K1.v
// Copyright (C) 2020 Klaus Kohl-Schoepe (kks@designin.de)
// =============================================================

// Testbench for myUART
`timescale 1 ns / 1 ps
`default_nettype wire

module Testbench ();
  reg  CLK12M;
  wire USER_BTN;
  wire tx;
  reg  rx;
  wire [5:0] BDBUS;
  wire [7:0] LED;

// =============================================================
// Top-Modul MAX1000_K1
//  Interfaces: RX/TX (115200 Baud UART), 8 LED, 12MHz Clock
// =============================================================

  MAX1000_K1 top(
    .CLK12M(CLK12M),     // 12MHz System Clock
    .USER_BTN(USER_BTN), // User Button
    .BDBUS(BDBUS),       // FTDI Chip
    .LED(LED)            // LEDS
  );

  assign BDBUS[0] = rx;  // for receiver test
  assign tx = BDBUS[1];  // outputs from uart
  
// =============================================================
// Initialisation for 12MHz clock
// =============================================================
  initial begin
    CLK12M <= 0;    // Clock starts with 0
//  USER_BTN <= 1;  // User button not used

//  reset <= 1;     // Reset sequence not used 
//  #100;
//  reset <= 0;
    
//  #10000000;
//  $stop;
  end

// =============================================================
// Run system with ~12MHz clock (41ps for half clock)
// =============================================================

  always begin
    #41 CLK12M <= ~CLK12M;
  end

  always begin
    #2000000 rx <= 1; // Wait 2ms
    // Send $2e = "." 
    #8680    rx <= 0; // Start
    #8680    rx <= 0; // Bit 0
    #8680    rx <= 1;
    #8680    rx <= 1;
    #8680    rx <= 1;
    #8680    rx <= 0;
    #8680    rx <= 1;
    #8680    rx <= 0;
    #8680    rx <= 0; // Bit 7
    #8680    rx <= 1; // Stop
    #8680    rx <= 1; // Stop

    // Send $73 = "." 
    #8680    rx <= 0; // Start
    #8680    rx <= 1; // Bit 0
    #8680    rx <= 1;
    #8680    rx <= 0;
    #8680    rx <= 0;
    #8680    rx <= 1;
    #8680    rx <= 1;
    #8680    rx <= 1;
    #8680    rx <= 0; // Bit 7
    #8680    rx <= 1; // Stop
    #8680    rx <= 1; // Stop

    // Send $0d 
    #8680    rx <= 0; // Start
    #8680    rx <= 1; // Bit 0
    #8680    rx <= 0;
    #8680    rx <= 1;
    #8680    rx <= 1;
    #8680    rx <= 0;
    #8680    rx <= 0;
    #8680    rx <= 0;
    #8680    rx <= 0; // Bit 7
    #8680    rx <= 1; // Stop
    #8680    rx <= 1; // Stop
	 end
  
endmodule
  